(function() {
    'use strict';

    /*
     *  TODO investigate dynamically setting the save delay value based on time taken to do DOM serialization
     *  This will allow persisting less complex message bodies more often, and more complex message bodies less often.
     */
    var MARK_AS_EDITED_DELAY_MS = 300;
    /**
     * An object which controls the auto save logic
     */
    window.autoSaveController = {
        composeContentNode: null,
        markAsEditedTimer: null,
        /**
         * A method which starts the autoSaveController
         */
        init: function(composeContentNode) {
            this.composeContentNode = composeContentNode;
            this.composeContentNode.addEventListener("input", this.handleInput.bind(this), false);
        },

        /**
         * A method which handles input events on the compose content and syncs the content back to native Java code
         */
        handleInput: function() {
            if (this.markAsEditedTimer) {
                window.clearTimeout(this.markAsEditedTimer)
            }
            this.markAsEditedTimer = window.setTimeout(this.handleMarkAsEdited.bind(this), MARK_AS_EDITED_DELAY_MS);
        },

        handleMarkAsEdited: function() {
            window.syncComposeContent(this.composeContentNode, false)
        }
    };
})();
